// // // // // // // // // // // // //
//
//	Game
//
//	erstellt 31.12.97 von Andreas Warnke
//	geändert 12.5.98 von Andreas Warnke
//



#ifndef Game_h_
#define Game_h_



// // // // // // // // // // // // //
//
//	include
//

#include "ServerApplication.h"
#include "ServerWelt.h"
#include "Spieler.h"
#include "FateMaker.h"
#include "Objekt.h"



// // // // // // // // // // // // //
//
//	Klasse Game:
//

class Game : public ServerApplication
{
private:
	//	Infos über das Spielfeld:
	ServerWelt * DieWelt;
	
	//	Sieg schon gefeiert?
	bool VictoryAlreadyCelebrated;
	
private:
	//	Methoden zur Message-Bearbeitung:
	void ClientLogin ( BMessage * inMessage );
	void ClientMove ( BMessage * inMessage );
	
	//	Methoden zum Verschicken von Messages:
	static void SendError (
		BMessenger inMessenger,
		const char * inClientName,
		const char * inClientPassword,
		int inErrorCode);
	static void SendError (
		Spieler * inAdressat,
		int inErrorCode);
	void SendWelcome (
		Spieler * inAdressat);
		
public:
	//	Konstruktor:
	Game ();
	
	//	Destruktor:
	virtual ~Game ();
	
	//	MessageReceived
	virtual void MessageReceived ( BMessage * inMessage );
	
	//	Pulse:
	virtual void Pulse ();
	
	//	CelebrateVictory 
	void CelebrateVictory ( unsigned int inID );
};



// // // // // // // // // // // // //
//
//	#define
//

enum { eEnableBuildingCities = 0 };



#endif



//
//	Ende
//
// // // // // // // // // // // // //